/*
 * Decompiled with CFR 0.152.
 */
package filenet.sim.toolkit.designer.message;

import filenet.sim.api.VWScenarioValidationError;
import filenet.sim.toolkit.designer.message.VWSIMValidationToolTip;
import filenet.vw.base.VWDebug;
import filenet.vw.toolkit.utils.VWStringUtils;
import java.awt.Component;
import javax.swing.JLabel;
import javax.swing.JTable;
import javax.swing.table.TableCellRenderer;

class VWSIMValidationMessageTableCellRenderer
extends JLabel
implements TableCellRenderer {
    public VWSIMValidationMessageTableCellRenderer() {
        try {
            this.setOpaque(true);
        }
        catch (Exception ex) {
            VWDebug.logException(ex);
        }
    }

    public Component getTableCellRendererComponent(JTable table, Object value, boolean isSelected, boolean hasFocus, int row, int column) {
        String msg = null;
        String errorString = null;
        VWScenarioValidationError error = null;
        if (value instanceof VWScenarioValidationError) {
            error = (VWScenarioValidationError)value;
        } else if (value instanceof String) {
            errorString = value.toString();
        }
        if (isSelected) {
            this.setBackground(table.getSelectionBackground());
            this.setForeground(table.getSelectionForeground());
        } else {
            this.setBackground(table.getBackground());
            this.setForeground(table.getForeground());
        }
        this.setFont(table.getFont());
        if (error != null) {
            msg = error.getMessage();
        } else if (errorString != null) {
            msg = errorString;
        }
        this.setText(msg);
        this.setToolTipText(error != null ? VWSIMValidationToolTip.createValidationToolTip(error) : VWStringUtils.formatToolTip(msg, 0));
        this.setComponentOrientation(table.getComponentOrientation());
        return this;
    }
}

